/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.Device88XException;
import com.quantumdata.autoupdate.Device88XIP;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SerialConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class Device88X {
    private final String defaultAddress = "000.000.000.000";
    private String m_IPAddress;
    private String m_SubnetMask;
    private String m_GatewayIP;
    private String m_ModelNum;
    private String m_verfString;
    private String m_vergString;
    private boolean m_skipBackupFlag;
    private String m_backupDir;
    private boolean m_usePCMCIA;
    private long m_TotalUpgradeBytes;
    private boolean m_doBootRomUpgrade;
    private String m_UpgradeURL;
    private String m_ZipFilePath;
    private String m_UnzippedPath;
    private String m_PcmciaCardLocation;
    private Device88XIP m_Dev88XIP;
    private SerialConnection m_Dev88XSerial;
    private String m_downloadSWVersion;
    private boolean m_localZipFile;
    private boolean m_freeSpaceCmdAvail;

    public Device88X() {
        this.initVars("000.000.000.000", "000.000.000.000", "000.000.000.000");
    }

    public Device88X(String string, String string2, String string3) {
        this.initVars(string, string2, string3);
    }

    private void initVars(String string, String string2, String string3) {
        this.m_IPAddress = string;
        this.m_SubnetMask = string2;
        this.m_GatewayIP = string3;
        this.m_usePCMCIA = false;
        this.m_skipBackupFlag = false;
        this.m_Dev88XIP = new Device88XIP(string);
        this.m_Dev88XSerial = null;
        this.m_ModelNum = "";
        this.m_vergString = "";
        this.m_verfString = "";
        this.m_freeSpaceCmdAvail = false;
        this.m_localZipFile = false;
    }

    public void setBaudRate(int n) {
        this.m_Dev88XSerial.setBaudRate(n);
    }

    public int getBaudRate() {
        return this.m_Dev88XSerial.getBaudRate();
    }

    public String getPortName() {
        return this.m_Dev88XSerial.getName();
    }

    public String[] getPortList() {
        return SerialConnection.getAvailablePortNames();
    }

    public void OpenComPort(String string, int n) {
        this.m_Dev88XSerial = new SerialConnection(string, n);
    }

    public void CloseComPort() throws Exception {
        this.m_Dev88XSerial.disconnect();
        this.m_Dev88XSerial = null;
    }

    public String getGatewayIP() {
        return this.m_GatewayIP;
    }

    public void setGatewayIP(String string) {
        this.m_GatewayIP = string;
    }

    public String getIPAddress() {
        return this.m_IPAddress;
    }

    public void setIPAddress(String string) {
        this.m_IPAddress = string;
        this.m_Dev88XIP.setIPAddress(string);
    }

    public String getSubnetMask() {
        return this.m_SubnetMask;
    }

    public void setSubnetMask(String string) {
        this.m_SubnetMask = string;
    }

    public void setVerfString(String string) {
        this.m_verfString = string;
    }

    public void setVergString(String string) {
        this.m_vergString = string;
    }

    public String getFirmwareVer() {
        if (this.m_verfString == "") {
            return "";
        }
        String[] stringArray = this.m_verfString.split("[,]");
        return stringArray[0];
    }

    public void setFirmwareVer(String string) {
        if (this.m_verfString == null || this.m_verfString == "") {
            this.m_verfString = string + ", ";
        } else {
            String[] stringArray = this.m_verfString.split("[,]");
            stringArray[0] = string;
            this.m_verfString = stringArray[0] + "," + stringArray[1];
        }
    }

    public String getBootRomVer() {
        if (this.m_verfString == "") {
            return "";
        }
        String[] stringArray = this.m_verfString.split("[,]");
        return stringArray[1];
    }

    public void setBootRomVer(String string) {
        if (this.m_verfString == null || this.m_verfString == "") {
            this.m_verfString = " ," + string;
        } else {
            String[] stringArray = this.m_verfString.split("[,]");
            stringArray[1] = string;
            this.m_verfString = stringArray[0] + "," + stringArray[1];
        }
    }

    public String getModelNum() {
        return this.m_ModelNum;
    }

    public void setModelNum(String string) {
        this.m_ModelNum = string;
    }

    public String getUpgradeURL() {
        return this.m_UpgradeURL;
    }

    public void setUpgradeURL(String string) {
        this.m_UpgradeURL = string;
    }

    public boolean isSkipBackupFlagSet() {
        return this.m_skipBackupFlag;
    }

    public void setSkipBackupFlag(boolean bl) {
        this.m_skipBackupFlag = bl;
    }

    public String getBackupDir() {
        return this.m_backupDir;
    }

    public void setBackupDir(String string) {
        this.m_backupDir = string;
    }

    public boolean isUsePCMCIA() {
        return this.m_usePCMCIA;
    }

    public void setUsePCMCIA(boolean bl) {
        this.m_usePCMCIA = bl;
    }

    public String getDownloadSWVersion() {
        return this.m_downloadSWVersion;
    }

    public void setDownloadSWVersion(String string) {
        this.m_downloadSWVersion = string;
    }

    public boolean useLocalZipFile() {
        return this.m_localZipFile;
    }

    public void setLocalZipFileFlag(boolean bl) {
        this.m_localZipFile = bl;
    }

    public String getZipFilePath() {
        return this.m_ZipFilePath;
    }

    public void setZipFilePath(String string) {
        this.m_ZipFilePath = string;
    }

    public String getUnzippedPath() {
        return this.m_UnzippedPath;
    }

    public void setUnzippedPath(String string) {
        this.m_UnzippedPath = string;
    }

    public boolean getBootRomUpgradeFlag() {
        return this.m_doBootRomUpgrade;
    }

    public void setBootRomUpgradeFlag(boolean bl) {
        this.m_doBootRomUpgrade = bl;
    }

    public String getPcmciaCardLocation() {
        return this.m_PcmciaCardLocation;
    }

    public void setPcmciaCardLocation(String string) {
        this.m_PcmciaCardLocation = string;
    }

    public long getTotalUpgradeBytes() {
        return this.m_TotalUpgradeBytes;
    }

    public void setTotalUpgradeBytes(long l) {
        this.m_TotalUpgradeBytes = l;
    }

    public String getVergString() {
        return this.m_vergString;
    }

    public String getGatewareVersions() {
        return this.getVergString();
    }

    public String getVerfString() {
        return this.m_verfString;
    }

    public void setGatewareVersion(String string, int n) {
        String[] stringArray = this.m_vergString == null || this.m_vergString == "" ? new String[3] : this.m_vergString.split("[:]");
        stringArray[n] = string;
        if (stringArray.length > n) {
            stringArray[n] = string;
        }
        this.m_vergString = stringArray[0] + ":" + stringArray[1] + ":" + stringArray[2];
    }

    public String getGatewareVersion(int n) {
        if (this.m_vergString == null || this.m_vergString == "") {
            return "";
        }
        String[] stringArray = this.m_vergString.split("[:]");
        return stringArray[n];
    }

    public boolean isfreeSpaceCmdAvail() {
        return this.m_freeSpaceCmdAvail;
    }

    public void setfreeSpaceCmdAvail(boolean bl) {
        this.m_freeSpaceCmdAvail = bl;
    }

    public boolean isConnected() {
        if (!this.m_usePCMCIA) {
            if (this.m_Dev88XIP == null) {
                return false;
            }
            return this.m_Dev88XIP.isConnected();
        }
        return false;
    }

    public boolean IsDeviceThere(JFrame jFrame) {
        return this.m_Dev88XIP.IsDeviceThere(jFrame);
    }

    public boolean getUpgradeInfo() {
        RemoteInstrument remoteInstrument = this.m_usePCMCIA ? new RemoteInstrument(this.m_Dev88XSerial, null) : new RemoteInstrument(this.m_Dev88XIP, null);
        try {
            remoteInstrument.connect();
        }
        catch (InstrumentException instrumentException) {
            JOptionPane.showMessageDialog(null, "Device Connection Error:  " + instrumentException.getLocalizedMessage(), "Error", 0);
            return false;
        }
        InstrumentResponse instrumentResponse = remoteInstrument.sendCmd("*idn?");
        if (instrumentResponse.isError()) {
            JOptionPane.showMessageDialog(null, "Error issuing \"*idn?\" command:  " + instrumentResponse.getResponse(), "Error", 0);
            remoteInstrument.disconnect();
            return false;
        }
        String string = instrumentResponse.getResponse();
        String[] stringArray = string.split(",");
        this.setModelNum(stringArray[1]);
        System.out.println("--->Model: " + this.getModelNum());
        instrumentResponse = remoteInstrument.sendCmd("verf?");
        if (instrumentResponse.isError()) {
            JOptionPane.showMessageDialog(null, "Error issuing \"verf?\" command:  " + instrumentResponse.getResponse(), "Error", 0);
            remoteInstrument.disconnect();
            return false;
        }
        string = instrumentResponse.getResponse();
        this.setVerfString(string);
        System.out.println("--->Firmware: " + this.getFirmwareVer());
        System.out.println("--->Boot ROM: " + this.getBootRomVer());
        instrumentResponse = remoteInstrument.sendCmd("verg?");
        if (instrumentResponse.isError()) {
            JOptionPane.showMessageDialog(null, "Error issuing \"verg?\" command:  " + instrumentResponse.getResponse(), "Error", 0);
            remoteInstrument.disconnect();
            return false;
        }
        string = instrumentResponse.getResponse();
        this.setVergString(string);
        System.out.println("--->Gateware String: " + string);
        remoteInstrument.disconnect();
        return true;
    }

    public synchronized long diffFileStructure(String string, String string2, JLabel jLabel, JProgressBar jProgressBar) throws IOException {
        File[] fileArray = new File(string).listFiles();
        File file = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object var10_10 = null;
        long l = 0L;
        jProgressBar.setIndeterminate(true);
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                string3 = string2 + File.separator + fileArray[i].getName();
                System.out.print("Checking : " + string3);
                file = new File(string3);
                l += file.length();
                if (file.exists()) {
                    System.out.print("... Exists\r\n");
                    if (!file.isDirectory()) continue;
                    string4 = string + File.separator + file.getName();
                    string5 = string2 + File.separator + file.getName();
                    l += this.diffFileStructure(string4, string5, jLabel, jProgressBar);
                    continue;
                }
                if (fileArray[i].isDirectory()) {
                    file.mkdirs();
                    jLabel.setText("Added: " + file.getPath());
                    System.out.print("... Added\r\n");
                    string4 = string + File.separator + file.getName();
                    string5 = string2 + File.separator + file.getName();
                    l += this.diffFileStructure(string4, string5, jLabel, jProgressBar);
                    continue;
                }
                if (string2.indexOf("System") != -1 && file.getName().indexOf(".bit") != -1) {
                    System.out.print("... Old FPGA file, not added\r\n");
                    continue;
                }
                jLabel.setText("Added: " + file.getPath());
                System.out.print("... Added\r\n");
                this.copyInputStream(new FileInputStream(fileArray[i]), new FileOutputStream(file), jLabel, jProgressBar);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            throw iOException;
        }
        return l;
    }

    public synchronized void copyInputStream(FileInputStream fileInputStream, FileOutputStream fileOutputStream, JLabel jLabel, JProgressBar jProgressBar) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        int n2 = 0;
        String string = jLabel.getText();
        if (jProgressBar != null) {
            jProgressBar.setValue(0);
        }
        while ((n = fileInputStream.read(byArray)) >= 0) {
            fileOutputStream.write(byArray, 0, n);
            n2 += n;
            if (jProgressBar != null) {
                jProgressBar.setValue(n2);
            }
            if (jLabel != null) {
                jLabel.setText(string + " ... " + (int)(jProgressBar.getPercentComplete() * 100.0) + "%");
            }
            Thread.yield();
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public synchronized void copyInputStream(InputStream inputStream, OutputStream outputStream, JLabel jLabel, JProgressBar jProgressBar) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        int n2 = 0;
        String string = jLabel.getText();
        if (jProgressBar != null) {
            jProgressBar.setValue(0);
        }
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
            n2 += n;
            if (jProgressBar != null) {
                jProgressBar.setValue(n2);
            }
            if (jLabel != null) {
                jLabel.setText(string + " ... " + (int)(jProgressBar.getPercentComplete() * 100.0) + "%");
            }
            Thread.yield();
        }
        inputStream.close();
        outputStream.close();
    }

    public boolean sendFlashBootRomCmd(int n) {
        RemoteInstrument remoteInstrument = this.m_usePCMCIA ? new RemoteInstrument(this.m_Dev88XIP, null) : new RemoteInstrument(this.m_Dev88XIP, null);
        try {
            remoteInstrument.connect();
        }
        catch (InstrumentException instrumentException) {
            JOptionPane.showMessageDialog(null, "Device Connection Error:  " + instrumentException.getMessage(), "Error", 0);
            return false;
        }
        InstrumentResponse instrumentResponse = remoteInstrument.sendCmd("FLSH BROM", n);
        if (instrumentResponse.isError()) {
            JOptionPane.showMessageDialog(null, "Device Connection Error:  " + instrumentResponse.getResponse(), "Error", 0);
            remoteInstrument.disconnect();
            return false;
        }
        System.out.println("Flashing the Boot ROM ");
        remoteInstrument.disconnect();
        return true;
    }

    public long getFlashFreeSpace(int n) throws Device88XException {
        long l = 0L;
        RemoteInstrument remoteInstrument = this.m_usePCMCIA ? new RemoteInstrument(this.m_Dev88XIP, null) : new RemoteInstrument(this.m_Dev88XIP, null);
        try {
            remoteInstrument.connect();
        }
        catch (InstrumentException instrumentException) {
            JOptionPane.showMessageDialog(null, "Device Connection Error:  " + instrumentException.getMessage(), "Error", 0);
            return -1L;
        }
        InstrumentResponse instrumentResponse = remoteInstrument.sendCmd("SYSX:FMEM? FILE", n);
        if (instrumentResponse.isError()) {
            if (instrumentResponse.getResponse().equalsIgnoreCase("Parse Error: 1")) {
                Device88XException device88XException = new Device88XException("Command Does Not Exist");
                device88XException.setErrorMessage("Command Does Not Exist:" + instrumentResponse.getResponse());
                remoteInstrument.disconnect();
                this.setfreeSpaceCmdAvail(false);
                throw device88XException;
            }
            JOptionPane.showMessageDialog(null, "Device Connection Error:  " + instrumentResponse.getResponse(), "Error", 0);
            remoteInstrument.disconnect();
            return -1L;
        }
        String string = instrumentResponse.getResponse();
        String[] stringArray = string.split(":");
        stringArray[1] = stringArray[1].trim();
        l = Long.parseLong(stringArray[1]);
        System.out.println("--->Free Flash Space: " + l + " Bytes");
        this.setfreeSpaceCmdAvail(true);
        remoteInstrument.disconnect();
        return l;
    }

    public synchronized void deleteFolder(String string, JLabel jLabel, JProgressBar jProgressBar) throws IOException {
        File[] fileArray = new File(string).listFiles();
        if (jProgressBar != null) {
            jProgressBar.setIndeterminate(true);
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            String string3 = string + File.separator + fileArray[i].getName();
            System.out.println("Deleting: " + string3);
            if (fileArray[i].isDirectory()) {
                if (jLabel != null) {
                    string2 = fileArray[i].getAbsolutePath();
                    if (string2.length() > 60) {
                        string2 = string2.substring(0, 30) + " ... " + string2.subSequence(string2.length() - 30, string2.length());
                        System.out.println("Truncated Display String =" + string2);
                    }
                    jLabel.setText("Retrieving Directory Listing for: " + string2);
                }
                this.deleteFolder(string3, jLabel, jProgressBar);
                Thread.yield();
                fileArray[i].delete();
                continue;
            }
            if (jLabel != null) {
                string2 = fileArray[i].getAbsolutePath();
                if (string2.length() > 60) {
                    string2 = string2.substring(0, 30) + " ... " + string2.subSequence(string2.length() - 30, string2.length());
                    System.out.println("Truncated Display String =" + string2);
                }
                jLabel.setText("Cleaning Up:  " + string2);
            }
            fileArray[i].delete();
        }
    }
}

